<?php
/*+*******************************************************************************
 *  The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *
 *********************************************************************************/

require_once 'include/db_backup/Targets/Target.php';

/**
 * Description of Response
 *
 * @author MAK
 */
class Response extends Target {

	/**
	 *
	 * @var DatabaseConfig
	 */
	private $dbConfig = null;

	public function __construct($dbConfig , $supportUTF8 = true) {
		$this->dbConfig = $dbConfig;
		$this->supportUTF8 = $supportUTF8;
	}

	protected function writeLine($string){
		echo $string,"\n";
	}

	public function startBackup() {
		$this->writeLine('-- Dump generated by vtigerCRM');
		$this->writeLine('-- Date: ' . date("D, M j, G:i:s T Y"));
		$this->writeLine('-- HOST: ' . $this->dbConfig->getHostName().
			' Database: '.$this->dbConfig->getDatabaseName());
		$this->writeLine("-- ----------------------------------");
		$this->writeLine("");

		$this->writeLine("/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;");
		$this->writeLine("/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;");
		$this->writeLine("/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;");
		$this->writeLine("/*!40101 SET NAMES utf8 */;");
		$this->writeLine("/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;");
		$this->writeLine("/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;");
		$this->writeLine("/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;");
		$this->writeLine("/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;");
	}

	public function processTableCreateStatement($data) {
		$tableName = $data[0];
		$sql = $data[1];
		$this->writeLine("");
		$this->writeLine("--");
		$this->writeLine("-- Table structure for table $tableName");
		$this->writeLine("--");
		$this->writeLine("");
		$this->writeLine("DROP TABLE IF EXISTS $tableName;");
		$this->writeLine("SET @saved_cs_client = @@character_set_client;");
		$this->writeLine("SET character_set_client = utf8;");
		$this->writeLine($sql.';');
		$this->writeLine("SET character_set_client = @saved_cs_client;");
		$this->writeLine("");
		$this->writeLine("--");
		$this->writeLine("-- Dumping data for table $tableName");
		$this->writeLine("--");
		$this->writeLine("");
	}

	public function startTableBackup($data) {
		$tableName = $data[0];
		$this->writeLine("LOCK TABLES `$tableName` WRITE;");
		$this->writeLine("/*!40000 ALTER TABLE `$tableName` DISABLE KEYS */;");
	}

	public function processStatement($data) {
		$stmt = $data[0];
		$this->writeLine($stmt);
	}

	public function finishTableBackup($data) {
		$tableName = $data[0];
		$this->writeLine("/*!40000 ALTER TABLE `$tableName` ENABLE KEYS */;");
		$this->writeLine("UNLOCK TABLES;");
	}

	public function finishBackup() {
		$this->writeLine("/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;");
		$this->writeLine("/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;");
		$this->writeLine("/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;");
		$this->writeLine("/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;");
		$this->writeLine("/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;");
		$this->writeLine("/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;");
		$this->writeLine("/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;");
		$this->writeLine("-- DONE");
	}
}
?>